package es.uniovi.healthappv2;

import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import java.util.ArrayList;

public class BuscarPulseraService extends Service {


    private BluetoothAdapter bluetoothAdapter;
    private boolean scanning=false;
    private Handler handler; // to handle a timeout for the scanning process
    private static final long SCAN_PERIOD = 10000;

    //Variable para la lista de encontrados
    private ArrayList<String> names;

    private ListView recientes;
    private ArrayList<String> recientes_text;

    //Listado de direcciones unicas
    private ArrayList<String> direcciones;

    //Contexto para la lista
    Context contexto;



    private static final int REQUEST_ENABLE_BT = 1;

    public void onCreate()
    {

        super.onCreate();

        names = new ArrayList<String>();
        recientes_text = new ArrayList<String>();
        direcciones = new ArrayList<String>();

        handler = new Handler();

        // Inicializar el Bluetooth Adapter
        final BluetoothManager bluetoothManager =
                (BluetoothManager) getSystemService(Context.BLUETOOTH_SERVICE);
        bluetoothAdapter = bluetoothManager.getAdapter();


        if (bluetoothAdapter == null || !bluetoothAdapter.isEnabled()) {
        }



        scanLeDevice(true);
        contexto=this;
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        scanLeDevice(true);
        return START_STICKY;

    }

    @Override
    public IBinder onBind(Intent intent) {
        // TODO: Return the communication channel to the service.
        throw new UnsupportedOperationException("Not yet implemented");
    }

    //Callback que se activa al encontrar un dispositivo BT
    private BluetoothAdapter.LeScanCallback callback =
            new BluetoothAdapter.LeScanCallback() {
                @Override
                public void onLeScan(final BluetoothDevice device, int rssi,
                                     byte[] scanRecord) {

                    Log.d("onLeScan()", "encontrado");
                    //Para no tener duplicados
                    if(!direcciones.contains(device.getAddress())){
                        names.add("Nombre: "+device.getName()+"\n"+"Dirección: "+device.getAddress());
                        direcciones.add(device.getAddress());
                    }
                }
            };


    //Método que realiza la búsqueda de dispositivos BT
    private void scanLeDevice(final boolean enable) {
        Toast.makeText(getApplicationContext(),
                "INICIO BÚSQUEDA", Toast.LENGTH_SHORT).show();

        if (enable) {
            // Para despues de SCAN_PERIOD
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    Toast.makeText(getApplicationContext(),
                            "FIN BÚSQUEDA", Toast.LENGTH_SHORT).show();
                    scanning = false;

                    sendMessageToActivity(names);
                    bluetoothAdapter.stopLeScan(callback);


                }
            }, SCAN_PERIOD);

            scanning = true;
            bluetoothAdapter.startLeScan(callback);
        } else {
            scanning = false;
            bluetoothAdapter.stopLeScan(callback);
            Intent myIntent = new Intent(this, MainActivity.class);
            startActivity(myIntent);


        }
    }
    //Se envía la lista de dispositivos encontrados
    private void sendMessageToActivity(ArrayList<String> datos) {
        Intent intent = new Intent("ActualizacionDispositivos");
        // You can also include some extra data.
        intent.putExtra("Dispositivos", datos);
        LocalBroadcastManager.getInstance(this).sendBroadcast(intent);
    }


}
