package es.uniovi.healthappv2;


import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.widget.Toast;

import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.github.mikephil.charting.charts.LineChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.listener.OnChartValueSelectedListener;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;


/**
 * A simple {@link Fragment} subclass.
 */
public class PulseraFragment extends Fragment {


    //Variables
    private TextView estado_conex;
    private TextView datos_ritmo;
    private TextView datos_pasos;
    private TextView datos_dia;
    private TextView datos_grafico;
    private TextView tEdad2;
    private TextView tReposo;
    private Button bConectar;
    private Button bAhora;
    private Button bParar;
    private Button bCalibrar;
    private EditText eEdad2;

    Spinner spinner;
    Spinner sDispositivos;
    private BluetoothLeService bluetoothLeService;
    private boolean connected = false;
    private ArrayList<ArrayList<BluetoothGattCharacteristic>> mGattCharacteristics;

    private String direccion;

    private final String LIST_NAME = "NAME";
    private final String LIST_UUID = "UUID";
    public static final String EXTRAS_DEVICE_NAME = "DEVICE_NAME";
    public static final String EXTRAS_DEVICE_ADDRESS = "DEVICE_ADDRESS";

    long UPDATE_PERIOD=1; //milisegundos



    LineChart lineChart;
    ArrayList<Map.Entry<String, Double>> medias_pulso;

    double ultimos_pasos;
    double ultimo_pulso;
    double ultimo_tiempo;
    double diferencia_pasos;
    double diferencia_tiempo;
    boolean medida;

    boolean primerDispo=false;

    Date primer_dia_grafico;
    double pasos;
    double calorias;
    double distancia;


    //Variables para la tabla
    private TableLayout tabla;
    private ArrayList<TableRow> filas;
    private Resources rs;
    private int FILAS, COLUMNAS;


    //Variables para detectar anomalías en el pulso
    double ext_inf_0;
    double ext_sup_0;
    double ext_inf_1;
    double ext_sup_1;
    double ext_inf_2;
    double ext_sup_2;
    double ext_inf_3;
    double ext_sup_3;

    int act_rangos=0;



    boolean calibrando=false;
    ArrayList<Double> datosCalib;

    double fcReposo;
    int edad;

    Timer timer;
    Alarm alarm;
    boolean alarma=false;



    ArrayList<Map.Entry<Long,String>> historial;
    boolean calibracion[];
    int count_0;
    int count_1;
    int count_2;
    int count_3;

    int MAX_CALIBRACION=100;

    boolean sleeping=false;
    double count_sleeping=0;

    double fuera_rango_0=0;
    double fuera_rango_1=0;
    double fuera_rango_2=0;
    double fuera_rango_3=0;

    public PulseraFragment() {
        // Required empty public constructor
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_pulsera, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {


        //Inicialización de variables
        estado_conex = (TextView) getActivity().findViewById(R.id.estado_conex);
        datos_ritmo = (TextView) getActivity().findViewById(R.id.datos_ritmo);
        datos_pasos = (TextView) getActivity().findViewById(R.id.datos_pasos);
        datos_grafico = (TextView) getActivity().findViewById(R.id.datos_grafico);
        tEdad2 = (TextView) getView().findViewById(R.id.tEdad2);
        tReposo = (TextView) getView().findViewById(R.id.tReposo);
        eEdad2=(EditText)  getActivity().findViewById(R.id.eEdad2);

        bConectar = (Button) getActivity().findViewById(R.id.bConectar);
        bConectar.setEnabled(false);
        bParar=(Button)getActivity().findViewById(R.id.bParar);
        bParar.setEnabled(false);
        bAhora=(Button)getActivity().findViewById(R.id.bAhora);
        bCalibrar=(Button)getActivity().findViewById(R.id.bCalibrar2);
        bCalibrar.setEnabled(false);



        spinner = (Spinner) getView().findViewById(R.id.spinner);
        spinner.setEnabled(false);
        sDispositivos = (Spinner) getView().findViewById(R.id.sDispositivos);

        datosCalib=new ArrayList<>();
        fcReposo=0;
        edad=-1;

        ultimos_pasos=0;
        ultimo_pulso=0;
        ultimo_tiempo=0;
        diferencia_pasos=0;
        diferencia_tiempo=0;
        medida=false;

        timer = new Timer();

        historial=new ArrayList<>();
        calibracion=new boolean[]{true,true,true,true};

        //Grafico
        lineChart = (LineChart) getActivity().findViewById(R.id.linechart);
        lineChart.setOnChartValueSelectedListener(chartListener);
        medias_pulso = new ArrayList<>();

        //Tabla
        tabla = (TableLayout) getView().findViewById(R.id.tabla);
        rs = getActivity().getResources();
        FILAS = COLUMNAS = 0;
        filas = new ArrayList<TableRow>();
        agregarCabecera(R.array.cabecera_tabla);
        for(int i = 0; i < 4; i++)
        {
            ArrayList<String> elementos = new ArrayList<String>();
            if (i == 0) {
                elementos.add("Sueño");
            }
            else if(i==1){
                elementos.add("Reposo");
            }
            else if(i==2){
                elementos.add("Moderada");
            }
            else if(i==3){
                elementos.add("Intensa");
            }

            elementos.add("N/A");
            elementos.add("N/A");
            elementos.add("N/A");
            agregarFilaTabla(elementos);
        }

        //Se obtiene la media de cada dia y se pinta el grafico
        obtenerMedias();
        pintarGrafico();


        //Inicializamos el spinner de los intervalos de actualizacion
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(getActivity(),
                R.array.intervalos_actualizacion, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spinner.setAdapter(adapter);
        spinner.setOnItemSelectedListener(
                new AdapterView.OnItemSelectedListener() {
                    public void onItemSelected(AdapterView<?> parent,
                                               View v, int position, long id) {
                        if(position==0){
                            return;
                        }

                        if(edad==-1 || fcReposo==0){
                            Toast.makeText(getActivity().getApplicationContext(),
                                    "PRIMERO INTRODUZCA SU EDAD O CALIBRE LA FC REPOSO", Toast.LENGTH_SHORT).show();
                            spinner.setSelection(0);
                        }
                        else if(calibrando){
                            Toast.makeText(getActivity().getApplicationContext(),
                                    "ACCIÓN NO PERMITIDA: CALIBRACIÓN EN CURSO", Toast.LENGTH_SHORT).show();
                            spinner.setSelection(0);
                        }
                        else{
                            long seleccion=Long.parseLong(parent.getItemAtPosition(position).toString());
                            Log.d("onItemSelected()",""+seleccion);

                            if(alarma){
                                alarm.cancelAlarm(getActivity());
                            }
                            alarma=true;
                            bParar.setEnabled(true);

                            UPDATE_PERIOD=seleccion;
                            count_sleeping=0;
                            alarm =new Alarm();
                            alarm.setAlarm(getActivity(), UPDATE_PERIOD);
                            Toast.makeText(getActivity().getApplicationContext(),
                                    "MIDIENDO...", Toast.LENGTH_SHORT).show();
                        }
                    }

                    @Override
                    public void onNothingSelected(AdapterView<?> parent) {
                    }
                });


        ArrayList<String> datos=new ArrayList<>();
        datos.add("Buscando dispositivos...");

        //Spinner con los dispositivos BT disponibles
        ArrayAdapter<String> adapter2=new ArrayAdapter<String>(getActivity(),
                android.R.layout.simple_spinner_dropdown_item,datos);
        sDispositivos.setAdapter(adapter2);

        sDispositivos.setOnItemSelectedListener(
                new AdapterView.OnItemSelectedListener() {
                    @Override
                    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {

                        if(position==0){

                        }
                        else{
                            String seleccion=parent.getItemAtPosition(position).toString();
                            if(!seleccion.substring(0,10).equals("(Reciente)")){
                                escribirEnFicheroP("DispReciente.txt",seleccion);
                            }
                            String dir=seleccion.split("Dirección: ")[1].substring(0,17);//Tamaño de la direccion exacto
                            direccion=dir;
                            bConectar.setEnabled(true);
                        }
                    }

                    @Override
                    public void onNothingSelected(AdapterView<?> parent) {

                    }
                }
        );

            //Servicio BluetoothLeService
            Intent bluetoothLeIntent = new Intent(getActivity(), BluetoothLeService.class);
            boolean b = getActivity().bindService(bluetoothLeIntent, serviceConnectionBluetooth, getActivity().BIND_AUTO_CREATE);

            //Receptor de datos desde BluetoothLeSErvice
            getActivity().registerReceiver(gattUpdateReceiver, makeGattUpdateIntentFilter());
            Log.d("onCreate()", "despues de registerReceiver");

            //Para recibir los dispositivos BT disponibles desde el servicio
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(
                    mMessageReceiver, new IntentFilter("ActualizacionDispositivos"));



        //Cargamos datos de fcReposo y edad
        if(leerFichero("FCReposo.txt")!=""){
            fcReposo=Double.valueOf(leerFichero("FCReposo.txt"));
            tReposo.setText("FC Reposo (Actual: "+String.valueOf(fcReposo).substring(0,2)+")");
        }
        else{
            tReposo.setText("FC Reposo (Actual: N/D)");
        }
        if(leerFichero("Edad.txt")!=""){
            edad=Integer.valueOf(leerFichero("Edad.txt").substring(0,2));
            tEdad2.setText("Edad (Actual: "+edad+")");
        }
        else{
            tEdad2.setText("Edad (Actual: N/D)");
        }


        String count=leerFichero("ContadoresCalibracion.txt");
        if(count!=""){
            count_0=Integer.valueOf(count.split("&")[0]);
            count_1=Integer.valueOf(count.split("&")[1]);
            count_2=Integer.valueOf(count.split("&")[2]);
            count_3=Integer.valueOf(count.split("&")[3]);
        }
        else{
            count_0=0;
            count_1=0;
            count_2=0;
            count_3=0;
        }
        if(count_0>MAX_CALIBRACION){
            calibracion[0]=false;
        }
        if(count_1>MAX_CALIBRACION){
            calibracion[1]=false;
        }
        if(count_2>MAX_CALIBRACION){
            calibracion[2]=false;
        }
        if(count_3>MAX_CALIBRACION){
            calibracion[3]=false;
        }

        //Rangos de pulso para cada actividad
        obtenerRangosPulso();

        //Se añade el listener para el broadcast que es enviado desde Alarm para indicar que se debe iniciar la medicion
        LocalBroadcastManager.getInstance(getActivity()).registerReceiver(
                ReceptorAlarma, new IntentFilter("Medir"));

        //Se inicia la búsqueda de dispositivos
        Intent myIntent = new Intent(getActivity(),BuscarPulseraService.class);
        getActivity().startService(myIntent);
    }

    //Receptor del broadcast desde Alarm. Se deeb iniciar la medicion
    private BroadcastReceiver ReceptorAlarma = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {

            double datos_recibidos=intent.getDoubleExtra("Mide",0);
            if(datos_recibidos==1.0){
                Date d = new Date(System.currentTimeMillis());
                String[] a = d.toString().split(" ");
                escribirEnFichero("Hr.txt", a[3]);
                pedirPasos();
                try {
                    Thread.sleep(500);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                activarHR();
            }
        }
    };

    @Override
    public void onDestroy() {
        getActivity().unbindService(serviceConnectionBluetooth);
        LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(mMessageReceiver);
        Intent myIntent = new Intent(getActivity(),BuscarPulseraService.class);
        getActivity().stopService(myIntent);

        if(alarma){
            alarm.cancelAlarm(getActivity());
        }
        super.onDestroy();


    }



    //Timer para realizar mediciones periódicas en función del periodo especificado por el usuario.
    class UpdateRitmo extends TimerTask {
        public void run() {
            pedirPasos();
            try {
                Thread.sleep(500);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            activarHR();
        }
    }

    private final BroadcastReceiver gattUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            final String action = intent.getAction();
            if (BluetoothLeService.ACTION_GATT_CONNECTED.equals(action)) {
                connected = true;
                updateConnectionState(R.string.connected);
                getActivity().invalidateOptionsMenu();

            } else if (BluetoothLeService.ACTION_GATT_DISCONNECTED.equals(action)) {
                connected = false;
                Log.d("gattUpdateReceiver","desconectado");
                updateConnectionState(R.string.disconnected);
                getActivity().invalidateOptionsMenu();
            } else if (BluetoothLeService.ACTION_GATT_SERVICES_DISCOVERED.equals(action)) {
                displayGattServices(bluetoothLeService.getSupportedGattServices());
                Log.d("gattUpdateReceiver","servicio encontrado");
            } else if (BluetoothLeService.ACTION_DATA_AVAILABLE.equals(action)) {
                Log.d("gattUpdateReceiver","datos disponibles, se muestran");
                if(!calibrando){
                    displayData(intent.getStringExtra(BluetoothLeService.EXTRA_DATA));
                }
                else{
                    guardarDatosCalibracion(intent.getStringExtra(BluetoothLeService.EXTRA_DATA));
                }
            }
        }
    };
    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {

            ArrayList<String> datos_recibidos=intent.getStringArrayListExtra("Dispositivos");
            if(primerDispo==false){
                datos_recibidos.add(0,"Dispositivos encontrados");
                if(leerFichero("DispReciente.txt").length()>0) {
                    datos_recibidos.add(1,"(Reciente)" + leerFichero("DispReciente.txt"));
                }
            }



            ArrayAdapter<String> adapter=new ArrayAdapter<String>(getActivity(),
                    android.R.layout.simple_spinner_dropdown_item,datos_recibidos);

            sDispositivos.setAdapter(adapter);
            primerDispo=true;
        }
    };

    private void updateConnectionState(final int resourceId) {
        //Propiedades de botones en función del estado de conexion
        getActivity().runOnUiThread(new Runnable() {
            @Override
            public void run() {

                if(resourceId== R.string.connected){
                    estado_conex.setText(resourceId);
                    estado_conex.setTextColor(Color.GREEN);
                }
                else{
                    estado_conex.setText(resourceId);
                    estado_conex.setTextColor(Color.RED);
                    spinner.setEnabled(false);
                    bAhora.setEnabled(false);
                    bCalibrar.setEnabled(false);

                }
            }
        });
    }

    //Se invoca cuando se reciben datos por BT
    private void displayData(String data) {
        Date d=new Date(System.currentTimeMillis());
        if (data != null) {
            Log.d("displayData(data)"," "+data);
            if(data.charAt(0)!='S'){
                //No es información de pasos, distancia y calorías
                if(medida==false && data!="0") {//Para tomar solo un valor

                    String[] a = d.toString().split(" ");

                    medida = true;
                    ultimo_pulso=Double.parseDouble(data);
                    procesarActividad(ultimo_pulso);

                    //Cada vez que se recibe un dato de pulso se refresca toda la info
                    obtener_min_max_media_pulso();
                    obtenerMedias();
                    pintarGrafico();
                }
            }
            else{

                double pasos_anteriores = ultimos_pasos;
                double tiempo_anterior= ultimo_tiempo;
                ultimos_pasos=Double.parseDouble(data.split(" ")[1]);
                ultimo_tiempo=System.currentTimeMillis();
                diferencia_tiempo=ultimo_tiempo-tiempo_anterior;
                diferencia_pasos = ultimos_pasos - pasos_anteriores;

                datos_pasos.setText(data.substring(1));

                pasos=Double.parseDouble(data.split(" ")[1]);
                distancia=Double.parseDouble(data.split(" ")[3]);
                calorias=Double.parseDouble(data.split(" ")[5]);


            }
        }
    }

    private static IntentFilter makeGattUpdateIntentFilter() {
        final IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(BluetoothLeService.ACTION_GATT_CONNECTED);
        intentFilter.addAction(BluetoothLeService.ACTION_GATT_DISCONNECTED);
        intentFilter.addAction(BluetoothLeService.ACTION_GATT_SERVICES_DISCOVERED);
        intentFilter.addAction(BluetoothLeService.ACTION_DATA_AVAILABLE);
        intentFilter.addAction(BluetoothLeService.ACTION_DATA_AVAILABLE);
        return intentFilter;
    }

    //Codigo para la conexion con el dispositivo bluetooth
    private final ServiceConnection serviceConnectionBluetooth = new ServiceConnection() {

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder service) {
            bluetoothLeService = ((BluetoothLeService.LocalBinder) service).getService();
            if (!bluetoothLeService.initialize()||bluetoothLeService==null) {
                Log.e("onServiceConnected()", "Error al inicializar Bt");
                getActivity().finish();
            }
            Log.d("onServiceConnected()", "Éxito al conectar");

        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            bluetoothLeService = null;
        }
    };

    //Listener para el gráfico. En funcion de donde se haga click se muestra en la tabla la info del dia seleccioando
    OnChartValueSelectedListener chartListener=new OnChartValueSelectedListener()
    {
        @Override
        public void onValueSelected(Entry e, Highlight h)
        {
            float x=e.getX();
            float y=e.getY();
            String fichero="";
            long milis;
            Date dia_sel;


            double actividad=0;
            double pm0=0;
            double pm1=0;
            double pm2=0;
            double pm3=0;

            double suma0=0;
            double suma1=0;
            double suma2=0;
            double suma3=0;

            int cont0=0;
            int cont1=0;
            int cont2=0;
            int cont3=0;

            double pmax0=0;
            double pmax1=0;
            double pmax2=0;
            double pmax3=0;
            double pmin0=300;
            double pmin1=300;
            double pmin2=300;
            double pmin3=300;


            double pasos=0;
            double calorias=0;
            double distancia=0;

            if(x==0){
                String[] a=primer_dia_grafico.toString().split(" ");
                fichero="Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
            }
            else{
                milis=primer_dia_grafico.getTime();
                milis=milis+(long)x*24*60*60*1000;
                dia_sel=new Date(milis);
                String[] a=dia_sel.toString().split(" ");
                fichero="Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
            }

            try {

                InputStream inputStream = getActivity().openFileInput(fichero);

                if (inputStream != null) {
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String receiveString = "";
                    ArrayList<Double> pulsos_dia = new ArrayList();

                    while ((receiveString = bufferedReader.readLine()) != null) {
                        String[] linea = receiveString.split("&");
                        actividad=Double.parseDouble(linea[3]);
                        double pulso=Double.parseDouble(linea[1]);

                        if(pulso!=0) {
                            if (actividad == 0) {
                                suma0 = suma0 + pulso;
                                cont0++;

                                if(pulso<pmin0){
                                    pmin0=pulso;
                                }
                                if(pulso>pmax0){
                                    pmax0=pulso;
                                }

                            } else if (actividad == 1) {
                                suma1 = suma1 + pulso;
                                cont1++;

                                if(pulso<pmin1){
                                    pmin1=pulso;
                                }
                                if(pulso>pmax1){
                                    pmax1=pulso;
                                }
                            } else if (actividad == 2) {
                                suma2 = suma2 + pulso;
                                cont2++;

                                if(pulso<pmin2){
                                    pmin2=pulso;
                                }
                                if(pulso>pmax2){
                                    pmax2=pulso;
                                }
                            }
                            else if (actividad == 3) {
                                suma3 = suma3 + pulso;
                                cont3++;

                                if(pulso<pmin3){
                                    pmin3=pulso;
                                }
                                if(pulso>pmax3){
                                    pmax3=pulso;
                                }
                            }
                        }

                        pasos=Double.parseDouble(linea[4]);
                        calorias=Double.parseDouble(linea[5]);
                        distancia=Double.parseDouble(linea[6]);

                    }

                }
            } catch (FileNotFoundException ex) {
                Log.e("login activity", "File not found: " + ex.toString());
            } catch (IOException ex) {
                Log.e("login activity", "Can not read file: " + ex.toString());
            }

            datos_grafico.setText("Pasos: "+pasos+"  Distancia(m): "+distancia+"  Calorías: "+calorias);

            pm0=suma0/cont0;
            pm1=suma1/cont1;
            pm2=suma2/cont2;
            pm3=suma3/cont3;

            actualizarTabla(pm0,pmin0,pmax0,pm1,pmin1,pmax1,pm2,pmin2,pmax2,pm3,pmin3,pmax3);
        }

        @Override
        public void onNothingSelected()
        {

        }
    };

    // Se llama cuando el usuario pulsa el botón
    public void onClickBConectar(View view) {
        bluetoothLeService.connect(direccion);

    }
    public void onClickBAhora(View view) {

        if(edad==-1 || fcReposo==0){
            Toast.makeText(getActivity().getApplicationContext(),
                    "PRIMERO INTRODUZCA SU EDAD O CALIBRE LA FC REPOSO", Toast.LENGTH_SHORT).show();
        }

        else if(calibrando){
            Toast.makeText(getActivity().getApplicationContext(),
                    "CALIBRACIÓN EN CURSO", Toast.LENGTH_SHORT).show();
        }
        else{
            pedirPasos();
            try {
                Thread.sleep(500);//Para darle tiempo a la pulsera para que procese la primera peticion
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            activarHR();
        }

    }

    public void onClickBParar(View view){
        if(alarma){
            alarm.cancelAlarm(getActivity());
            spinner.setSelection(0);
        }
    }

    public void onClickBLeerFichero(View view) {
        leerFichero("Hr.txt");
        obtenerRangosPulso();

    }
    public void onClickBConfirmar(View view){
        String s= String.valueOf(eEdad2.getText());
        tEdad2.clearFocus();
        getActivity().getWindow().getDecorView().clearFocus();
        if(!s.equals("")){
            int ed=Integer.valueOf(s);
            if(ed>=0 && ed<=100){
                escribirEnFicheroP("Edad.txt",s);
                edad=ed;
                tEdad2.setText("Edad (Actual: "+edad+")");
                return;
            }
        }
        Toast.makeText(getActivity().getApplicationContext(),
                "EDAD INCORRECTA", Toast.LENGTH_SHORT).show();

    }
    public void onClickBCalibrar(View view){
        calibrando=true;
        datosCalib.clear();
        //tiempo_fcreposo=0;
        timer.cancel(); //Se cancela el timer si se estaba haciendo una medición periodica


        new Thread() {
            @Override
            public void run() {
                for (int i=0;i<10;i++){

                    pedirPasos();
                    try {
                        Thread.sleep(500);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }

                    activarHR();

                    try {
                        Thread.sleep(30*1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                calibrando=false;
                double min=300;
                for(int i=0;i<datosCalib.size();i++){
                    if(datosCalib.get(i)<min){
                        min=datosCalib.get(i);
                    }
                }
                escribirEnFicheroP("FCReposo.txt",min+"");
                fcReposo=min;
                //Para podeer actualizar la UI desde el hilo
                handler.sendMessage(new Message());
            }
        }.start();
    }

    //Para podeer actualizar la UI desde el hilo
    final Handler handler = new Handler(){
        @Override
        public void handleMessage(Message msg) {
            tReposo.setText("FC Reposo (Actual: "+String.valueOf(fcReposo).substring(0,2)+")");
            Toast.makeText(getActivity().getApplicationContext(),
                    "CALIBRACION FINALIZADA", Toast.LENGTH_SHORT).show();
            super.handleMessage(msg);
        }
    };

    public void guardarDatosCalibracion(String dato){
        if(dato.charAt(0)!='S'){
            Double pulso=Double.valueOf(dato);
            Log.d("GUARDAR DATO","GUARDAR"+dato);
            if(pulso!=0){
                datosCalib.add(pulso);
            }
        }

    }


    public void activarNotificaciones() { //Permite recibir la info del pulso
        Log.d("onClickBCRitmo()","INICIO");
        for (int i=0;i<mGattCharacteristics.size();i++){
            for(int j=0;j<mGattCharacteristics.get(i).size();j++){
                //Se lee la caracteristica del ritmo
                if(mGattCharacteristics.get(i).get(j).getUuid().toString().equals(SampleGattAttributes.UUID_HEART_RATE_MEASUREMENT)){
                    bluetoothLeService.setCharacteristicNotification(mGattCharacteristics.get(i).get(j),true);
                    Log.d("onClickBCRitmo()j","Llamado a setNot");
                }
            }
        }
    }

    //Para pedir datos de pulso
    public void activarHR(){

        activarNotificaciones();
        try {
            Thread.sleep(500);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        medida=false;
        //https://medium.com/machine-learning-world/how-i-hacked-xiaomi-miband-2-to-control-it-from-linux-a5bd2f36d3ad
        byte[] value = new byte[3];
        value[0]=0x15;
        value[1]=0x01;
        value[2]=0x01;

        for (int i=0;i<mGattCharacteristics.size();i++){
            for(int j=0;j<mGattCharacteristics.get(i).size();j++){

                //Se lee la caracteristica del ritmo
                if(mGattCharacteristics.get(i).get(j).getUuid().toString().equals(SampleGattAttributes.UUID_HEART_RATE_CONTROL_POINT)){
                    boolean b=bluetoothLeService.writeCharacteristic(mGattCharacteristics.get(i).get(j),value);
                    Log.d("onClickBAhora()j","Llamado a writeChar"+b);
                }

            }
        }
    }

    //Para pedir datos de pasos, calorias y distancia
    public void pedirPasos(){
        bluetoothLeService.pasos();
    }


    //Se calcula el tipo de actividad, se almacena y se envía notificación en caso de situación anómala
    public void procesarActividad(double pulso) {

        if (pulso == 0) {//Valor que devuelve en algunas ocasiones
            return;
        }

        Date d = new Date(System.currentTimeMillis());
        String[] a = d.toString().split(" ");
        double pasos_minuto = diferencia_pasos / (diferencia_tiempo / 1000 / 60);
        int tipo_actividad;
        if (diferencia_tiempo > 1000 * 60 * 60 * 24) {//Si la diferencia de tiempo es mayor que 1 dia (primer arranque)
            tipo_actividad = 1;
        }
        else if (pasos_minuto == 0) {
            tipo_actividad = 1;
        } else if (pasos_minuto <= 130) {
            tipo_actividad = 2;
        } else {
            tipo_actividad = 3;
        }

        //count_sleeping va almacenando los minutos en actividad reposo seguidos
        if(tipo_actividad==1 && diferencia_tiempo < 1800000){
            count_sleeping=count_sleeping+(diferencia_tiempo / 1000 / 60);
        }
        else{
            count_sleeping=0;
        }

        act_rangos++;
        if(act_rangos>=50){
            obtenerRangosPulso();
            act_rangos=0;
        }

        if(pulso>220-edad){
            enviar_notificacion("FC máxima superada ("+pulso+"PPM)");
        }
        if (pulso<40){
            enviar_notificacion("FC muy baja ("+pulso+"PPM)");
        }


        int hora_actual=Integer.parseInt(a[3].split(":")[0]);

        if(count_sleeping>30 && hora_actual>=0 && hora_actual<8) {
            tipo_actividad=0;
        }
        String salida="";
        if(tipo_actividad==1){
            salida="Reposo";
        }
        else if(tipo_actividad==0){
            salida="Sueño";
        }
        else if(tipo_actividad==2){
            salida="Moderado";
        }
        else if(tipo_actividad==3){
            salida="Intenso";
        }


        datos_ritmo.setText("Frecuencia cardiaca: "+pulso+"PPM a las "+a[3] +"\nNivel de actividad: "+salida);

        if(historial.size()==3){
            historial.remove(0);
            historial.add(new AbstractMap.SimpleEntry<Long, String>(System.currentTimeMillis()/1000,String.valueOf(pulso)+"&"+tipo_actividad));
        }
        else{
            historial.add(new AbstractMap.SimpleEntry<Long, String>(System.currentTimeMillis()/1000,String.valueOf(pulso)+"&"+tipo_actividad));
        }


        //La actividad se encuentra en fase de calibracion
        if(calibracion[tipo_actividad]){
            if(historial.size()==3){

                long intervalo = historial.get(historial.size() - 1).getKey() - historial.get(historial.size() - 2).getKey();
                long intervalo2 = historial.get(historial.size() - 1).getKey() - historial.get(historial.size() - 3).getKey();

                //Medicion cada minuto
                if(UPDATE_PERIOD==1){
                    Log.d("procesarActividad","CCC Medicion cada minuto");
                    //La actividad actual tiene que ser igual que las 2 anteriores
                    if (tipo_actividad==Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1]) &&
                        tipo_actividad==Integer.valueOf(historial.get(historial.size() - 3).getValue().split("&")[1])){
                        Log.d("procesarActividad","CCC Medicion cada minuto- coinciden actividades");
                        gestionarCalibracion(tipo_actividad, pulso, pasos_minuto);
                    }
                }
                // Medición cada 2min
                else if(UPDATE_PERIOD==2){
                // La actividad actual tiene que ser igual que la anterior
                    if (tipo_actividad==Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1])){
                        Log.d("procesarActividad","CCC Medicion cada 2 minutoS");
                        gestionarCalibracion(tipo_actividad, pulso, pasos_minuto);
                    }
                }
                //Si el intervalo de medicion es mayor de 2 min no vale para calibracion
            }
        }
        //La actividad no se encuentra en calibración
        else{
            Log.d("NO CALIBRACION","NO CALIBRACION");

            if(historial.size()==3){
                double pulso_anterior = Double.parseDouble(historial.get(historial.size() - 2).getValue().split("&")[0]);
                double pulso_anterior2 = Double.parseDouble(historial.get(historial.size() - 3).getValue().split("&")[0]);

                //Si la medicion es cada minuto
                if(UPDATE_PERIOD==1){


                    //Salto de actividad entre el min actual y el anterior y recuperacion mala. Se requiere que dos minutos antes tambien esté realizando una mayor actividad para que sea una actividad mas consolidada.
                    //Si la actividad actual es sueño no se contempla la mala recuperacion
                    if(tipo_actividad < Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1]) && pulso>pulso_anterior-11 &&
                            tipo_actividad < Integer.valueOf(historial.get(historial.size() - 3).getValue().split("&")[1]) && tipo_actividad!=0){
                        enviar_notificacion("Recuperación de la FC anormal");
                        Log.d("MALA RECU","MALA RECU1");
                    }

                    //Mala recuperación entre el min actual y el 2 min antes. En el miuto intermedio, la actividad tambien tiene que ser menor que el minuto anterior.
                    else if(tipo_actividad < Integer.valueOf(historial.get(historial.size() - 3).getValue().split("&")[1]) && pulso>pulso_anterior2-21 &&
                            Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1]) < Integer.valueOf(historial.get(historial.size() - 3).getValue().split("&")[1])
                            && tipo_actividad!=0){
                        enviar_notificacion("Recuperación de la FC anormal");
                        Log.d("MALA RECU","MALA RECU2");
                    }

                    //La actividad actual es la misma que 2 min antes, se mira si está dentro de rango y se anota. Fuera de rango -> Alerta
                    else if(tipo_actividad==Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1])  &&
                            tipo_actividad==Integer.valueOf(historial.get(historial.size() - 3).getValue().split("&")[1])){
                        Log.d("procesarActividad","Medicion cada minuto, SE ANOTA");
                        gestionarPulsoActividad(tipo_actividad,pulso, pasos_minuto);
                    }
                }

                //Si la medicion es cada 2 minutos
                else if(UPDATE_PERIOD==2){

                    //Salto de actividad entre el momento actual y 2 min antes y mala recuperacion
                    if(tipo_actividad < Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1]) && pulso>pulso_anterior-21 && tipo_actividad!=0){
                        enviar_notificacion("Recuperación de la FC anormal");
                        Log.d("MALA RECU","MALA RECU2min");
                    }

                    //Actividad actual es la misma que hace 2 min
                    else if(tipo_actividad==Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1])  &&
                            tipo_actividad==Integer.valueOf(historial.get(historial.size() - 3).getValue().split("&")[1])){
                        Log.d("procesarActividad","Medicion cada 2 minutoS, SE ANOTA");
                        gestionarPulsoActividad(tipo_actividad,pulso, pasos_minuto);
                    }
                }
                //Mediciones cada mas tiempo, no se tienen en cuenta actividades anteriores por su lejanía en el tiempo
                else if(UPDATE_PERIOD>2){
                    Log.d("procesarActividad","Medicion cada MUCHO, SE ANOTA");
                    gestionarPulsoActividad(tipo_actividad,pulso, pasos_minuto);
                }
            }
        }
    }


    public void gestionarPulsoActividad(int actividad, double pulso, double pasos_minuto){

        Date d = new Date(System.currentTimeMillis());
        String[] a = d.toString().split(" ");
        Log.d("gestionarPulsoACT","Inicio");
        if(actividad==0){
            if(pulso<ext_inf_0 || pulso>ext_sup_0){

                if(diferencia_tiempo < 1800000){
                    fuera_rango_0=fuera_rango_0+(diferencia_tiempo / 1000 / 60);
                }
                if(fuera_rango_0>=10){
                    enviar_notificacion("FC anormal durante el Sueño ("+pulso+"PPM)");
                }
                Log.d("gestionarPulsoACT","Anormal0");

                String nombre_fich="Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
                String datos=a[3]+"&"+pulso+"&"+pasos_minuto+"&"+actividad+"&"+pasos+"&"+calorias+"&"+distancia;
                escribirEnFichero(nombre_fich, datos);

                return;
            }
        }
        else if(actividad==1){
            if(pulso<ext_inf_1 || pulso>ext_sup_1){

                if(diferencia_tiempo < 1800000){
                    fuera_rango_1=fuera_rango_1+(diferencia_tiempo / 1000 / 60);
                }
                if(fuera_rango_1>=10){
                    enviar_notificacion("FC anormal durante el Reposo ("+pulso+"PPM)");
                }
                Log.d("gestionarPulsoACT","Anormal1"+diferencia_tiempo+"//"+fuera_rango_1);

                String nombre_fich="Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
                String datos=a[3]+"&"+pulso+"&"+pasos_minuto+"&"+actividad+"&"+pasos+"&"+calorias+"&"+distancia;
                escribirEnFichero(nombre_fich, datos);
                return;
            }
        }
        else if(actividad==2){
            if(pulso<ext_inf_2 || pulso>ext_sup_2){
                if(diferencia_tiempo < 1800000){
                    fuera_rango_2=fuera_rango_2+(diferencia_tiempo / 1000 / 60);
                }
                if(fuera_rango_2>=6){
                    enviar_notificacion("FC anormal durante la actividad Moderada ("+pulso+"PPM)");
                }
                Log.d("gestionarPulsoACT","Anormal2");

                String nombre_fich="Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
                String datos=a[3]+"&"+pulso+"&"+pasos_minuto+"&"+actividad+"&"+pasos+"&"+calorias+"&"+distancia;
                escribirEnFichero(nombre_fich, datos);
                return;
            }
        }
        else if(actividad==3){
            if(pulso<ext_inf_3 || pulso>ext_sup_3){
                if(diferencia_tiempo < 1800000){
                    fuera_rango_3=fuera_rango_3+(diferencia_tiempo / 1000 / 60);
                }
                if(fuera_rango_3>=4){
                    enviar_notificacion("FC anormal durante la actividad Intensa ("+pulso+"PPM)");
                }

                Log.d("gestionarPulsoACT","Anormal3");

                String nombre_fich="Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
                String datos=a[3]+"&"+pulso+"&"+pasos_minuto+"&"+actividad+"&"+pasos+"&"+calorias+"&"+distancia;
                escribirEnFichero(nombre_fich, datos);
                return;
            }
        }
        fuera_rango_0=0;
        fuera_rango_1=0;
        fuera_rango_2=0;
        fuera_rango_3=0;
        String nombre_fich="Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
        String datos=a[3]+"&"+pulso+"&"+pasos_minuto+"&"+actividad+"&"+pasos+"&"+calorias+"&"+distancia;
        escribirEnFichero(nombre_fich, datos);
        Log.d("gestionarPulsoACT","ANOTADO"+actividad);
    }

    public void gestionarCalibracion(int actividad, double pulso, double pasos_minuto){

        Date d = new Date(System.currentTimeMillis());
        String[] a = d.toString().split(" ");

        Log.d("gestionarcALIBRACION","INICIO");

        //Para la actividad de sueño se impone la restriccion de [40,100]
        if(actividad==0 && pulso <= 100 && pulso >= 40){
            String nombre_fich="Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
            String datos=a[3]+"&"+pulso+"&"+pasos_minuto+"&"+actividad+"&"+pasos+"&"+calorias+"&"+distancia;
            escribirEnFichero(nombre_fich, datos);
            count_0++;
            escribirEnFicheroP("ContadoresCalibracion.txt", count_0+"&"+count_1+"&"+count_2+"&"+count_3+"&");
            Log.d("gestionarcALIBRACION","ANOTADO0"+"//"+count_0);
            if(count_0>MAX_CALIBRACION){
                calibracion[actividad]=false;
                obtenerRangosPulso();
                Log.d("gestionarcALIBRACION","ALCANZADO MAX0");
            }
        }
        //Para el resto de actividades se guarda directamente
        else if(actividad==1 && pulso <= 100 && pulso >= fcReposo){
            String nombre_fich="Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
            String datos=a[3]+"&"+pulso+"&"+pasos_minuto+"&"+actividad+"&"+pasos+"&"+calorias+"&"+distancia;
            escribirEnFichero(nombre_fich, datos);
            count_1++;
            escribirEnFicheroP("ContadoresCalibracion.txt", count_0+"&"+count_1+"&"+count_2+"&"+count_3+"&");
            Log.d("gestionarcALIBRACION","ANOTADO1");
            if(count_1>MAX_CALIBRACION){
                calibracion[actividad]=false;
                obtenerRangosPulso();
                Log.d("gestionarcALIBRACION","ALCANZADO MAX1");
            }
        }
        else if (actividad==2 && pulso <= 0.7*(220-edad) && pulso >= 0.5*(220-edad)){
            String nombre_fich="Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
            String datos=a[3]+"&"+pulso+"&"+pasos_minuto+"&"+actividad+"&"+pasos+"&"+calorias+"&"+distancia;
            escribirEnFichero(nombre_fich, datos);
            count_2++;
            escribirEnFicheroP("ContadoresCalibracion.txt", count_0+"&"+count_1+"&"+count_2+"&"+count_3+"&");
            Log.d("gestionarcALIBRACION","ANOTADO2");
            if(count_2>MAX_CALIBRACION){
                calibracion[actividad]=false;
                obtenerRangosPulso();
                Log.d("gestionarcALIBRACION","ALCANZADO MAX2");
            }
        }
        else if (actividad==3&& pulso <= 0.9*(220-edad) && pulso >= 0.7*(220-edad)){
            String nombre_fich="Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
            String datos=a[3]+"&"+pulso+"&"+pasos_minuto+"&"+actividad+"&"+pasos+"&"+calorias+"&"+distancia;
            escribirEnFichero(nombre_fich, datos);
            count_3++;
            escribirEnFicheroP("ContadoresCalibracion.txt", count_0+"&"+count_1+"&"+count_2+"&"+count_3+"&");
            Log.d("gestionarcALIBRACION","ANOTADO3");
            if(count_3>MAX_CALIBRACION){
                calibracion[actividad]=false;
                obtenerRangosPulso();
                Log.d("gestionarcALIBRACION","ALCANZADO MAX3");
            }
        }
    }

    //Se obtienen pulso min, max y medio del dia para mostrarlo en la interfaz
    public void obtener_min_max_media_pulso(){

        double min=300;
        double max=0;
        double media=0;
        double suma=0;


        Date d=new Date(System.currentTimeMillis());
        String[] a=d.toString().split(" ");

        String s=leerFichero("Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt");

        if(s!="") {
            String[] lineas = s.split("\n");
            for (int i = 0; i < lineas.length; i++) {
                String temp = lineas[i].split("&")[1];
                double pulso = Double.parseDouble(temp);
                if (pulso > max) {
                    max = pulso;
                }
                if (pulso < min) {
                    min = pulso;
                }
                suma = suma + pulso;
            }
            media = suma / lineas.length;
        }
    }


    //Se obtienen los pulsos medios de los ultimos 15 dias para mostrarlos en el grafico
    public void obtenerMedias(){
        long milis_dia=24*60*60*1000;
        medias_pulso.clear();
        Date d=new Date(System.currentTimeMillis()-milis_dia*15);
        boolean encontrado=false; //Variable para detectar si faltan datos en algun dia intermedio
        double media=0;

        for (int i=14;i>=0;i--) { //Para los ultimos 15 dias
            d=new Date(System.currentTimeMillis()-milis_dia*i);
            String[] a=d.toString().split(" ");

            try {
                InputStream inputStream = getActivity().openFileInput("Actividad_"+a[1]+"_"+a[2]+"_"+a[5]+".txt");
                if(encontrado==false){
                    primer_dia_grafico=d;
                }
                encontrado=true;

                if (inputStream != null) {
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String receiveString = "";
                    ArrayList<Double> pulsos_dia = new ArrayList();
                    double suma=0;
                    int contador=0;

                    while ((receiveString = bufferedReader.readLine()) != null) {
                        String[] linea = receiveString.split("&");
                        Double pulso=Double.parseDouble(linea[1]);
                        if(pulso!=0){ //Para eliminar valores de 0 que devuelve a veces la pulsera
                            suma=suma+pulso;
                            contador++;
                        }
                    }
                    media=suma/contador;
                    Map.Entry<String,Double> entrada= new AbstractMap.SimpleEntry<String, Double>(a[1]+"_"+a[2],media);
                    medias_pulso.add(entrada);
                }
            } catch (FileNotFoundException e) {
                Log.e("login activity", "File not found: " + e.toString());
                if(encontrado==true){//Faltan datos en un dia intermedio
                    Map.Entry<String,Double> entrada= new AbstractMap.SimpleEntry<String, Double>(a[1]+"_"+a[2],media);
                    medias_pulso.add(entrada);
                }
            } catch (IOException e) {
                Log.e("login activity", "Can not read file: " + e.toString());
            }
        }
        for (int i=0;i<medias_pulso.size();i++){
            Log.d("mediasPulso",medias_pulso.get(i).getKey()+"xxx"+medias_pulso.get(i).getValue());
        }
    }

    //Se obtienen los rangos del pulso para cada tipo de actividad en función de todos los datos de los datos recogidos previamente
    public void obtenerRangosPulso(){
        ArrayList<Double> pulsos_act0=new ArrayList<>();
        ArrayList<Double> pulsos_act1=new ArrayList<>();
        ArrayList<Double> pulsos_act2=new ArrayList<>();
        ArrayList<Double> pulsos_act3=new ArrayList<>();

        double suma_media_0=0;
        double contador_media_0=0;
        double suma_media_1=0;
        double contador_media_1=0;
        double suma_media_2=0;
        double contador_media_2=0;
        double suma_media_3=0;
        double contador_media_3=0;

        File f = new File(getActivity().getFilesDir().toString());
        File[] files = f.listFiles();
        if(files.length>0) {
            for (int i = 0; i < files.length; i++) {
                if(files[i].getName().length()>10){
                if (files[i].getName().substring(0, 10).equals("Actividad_")) {

                    try {
                        InputStream inputStream = getActivity().openFileInput(files[i].getName());

                        if (inputStream != null) {
                            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                            String receiveString = "";


                            while ((receiveString = bufferedReader.readLine()) != null) {
                                String[] s = receiveString.split("&");
                                if (s[3].equals("0")) {
                                    pulsos_act0.add(Double.valueOf(s[1]));
                                    contador_media_0++;
                                    suma_media_0 = suma_media_0 + Double.valueOf(s[1]);
                                } else if (s[3].equals("1")) {
                                    pulsos_act1.add(Double.valueOf(s[1]));
                                    contador_media_1++;
                                    suma_media_1 = suma_media_1 + Double.valueOf(s[1]);
                                } else if (s[3].equals("2")) {
                                    pulsos_act2.add(Double.valueOf(s[1]));
                                    contador_media_2++;
                                    suma_media_2 = suma_media_2 + Double.valueOf(s[1]);
                                }
                                else if (s[3].equals("3")) {
                                    pulsos_act3.add(Double.valueOf(s[1]));
                                    contador_media_3++;
                                    suma_media_3 = suma_media_3 + Double.valueOf(s[1]);
                                }
                            }
                            inputStream.close();
                        }
                    } catch (FileNotFoundException e) {
                        Log.e("login activity", "File not found: " + e.toString());
                    } catch (IOException e) {
                        Log.e("login activity", "Can not read file: " + e.toString());
                    }
                }}
            }//acaba for
        }
        double media_0=suma_media_0/contador_media_0;
        double media_1=suma_media_1/contador_media_1;
        double media_2=suma_media_2/contador_media_2;
        double media_3=suma_media_3/contador_media_3;

        Collections.sort(pulsos_act0);
        Collections.sort(pulsos_act1);
        Collections.sort(pulsos_act2);
        Collections.sort(pulsos_act3);


        if(pulsos_act0.size()>0) {
            double suma_d0 = 0;
            for (int i = 0; i < pulsos_act0.size(); i++) {
                suma_d0 = suma_d0 + Math.pow((pulsos_act0.get(i) - media_0), 2);
            }
            double desv_0 = Math.sqrt(suma_d0 / (pulsos_act0.size() - 1));
            ext_inf_0 = media_0 - 1.5*desv_0;
            ext_sup_0 = media_0 + 1.5*desv_0;
        }

        if(pulsos_act1.size()>0) {
            double suma_d1 = 0;
            for (int i = 0; i < pulsos_act1.size(); i++) {
                suma_d1 = suma_d1 + Math.pow((pulsos_act1.get(i) - media_1), 2);
            }
            double desv_1 = Math.sqrt(suma_d1 / (pulsos_act1.size() - 1));
            ext_inf_1 = media_1 - 1.5*desv_1;
            ext_sup_1 = media_1 + 1.5*desv_1;
        }

        if(pulsos_act2.size()>0) {
            double suma_d2 = 0;
            for (int i = 0; i < pulsos_act2.size(); i++) {
                suma_d2 = suma_d2 + Math.pow((pulsos_act2.get(i) - media_2), 2);
            }
            double desv_2 = Math.sqrt(suma_d2 / (pulsos_act2.size() - 1));
            ext_inf_2 = media_2 - 1.5*desv_2;
            ext_sup_2 = media_2 + 1.5*desv_2;
        }

        if(pulsos_act3.size()>0) {
            double suma_d3 = 0;
            for (int i = 0; i < pulsos_act3.size(); i++) {
                suma_d3 = suma_d3 + Math.pow((pulsos_act3.get(i) - media_3), 2);
            }
            double desv_3 = Math.sqrt(suma_d3 / (pulsos_act3.size() - 1));
            ext_inf_3 = media_3 - 1.5*desv_3;
            ext_sup_3 = media_3 + 1.5*desv_3;
        }

        Log.d("obetenerRangosPulso(D)","["+ext_inf_0+","+ext_sup_0+"]"+"["+ext_inf_1+","+ext_sup_1+"]"+"["+ext_inf_2+","+ext_sup_2+"]"+"["+ext_inf_3+","+ext_sup_3+"]");

    }

    //Se pinta el gráfico
    public void pintarGrafico(){


        if(medias_pulso.size()>0) {
            DecimalFormat df = new DecimalFormat("#");
            ArrayList<Entry> incomeEntries = new ArrayList<>();

            for (int i = 0; i < medias_pulso.size(); i++) {
                incomeEntries.add(new Entry(i, Math.round(medias_pulso.get(i).getValue())));

            }

            ArrayList<ILineDataSet> dataSets = new ArrayList<>();
            List<String> xAxisValues = new ArrayList<>();
            for (int i = 0; i < medias_pulso.size(); i++) {
                xAxisValues.add(medias_pulso.get(i).getKey());
            }

            dataSets = new ArrayList<>();
            LineDataSet set1;

            set1 = new LineDataSet(incomeEntries, "Income");
            set1.setColor(Color.RED);
            set1.setValueTextColor(Color.BLACK);
            set1.setValueTextSize(10f);
            set1.setCircleColor(Color.RED);
            set1.setMode(LineDataSet.Mode.LINEAR);
            dataSets.add(set1);


            lineChart.setTouchEnabled(true);
            lineChart.setDragEnabled(true);
            lineChart.setScaleEnabled(false);
            lineChart.setPinchZoom(false);
            lineChart.setDrawGridBackground(false);

            lineChart.getXAxis().setDrawGridLines(false);
            lineChart.getAxisLeft().setDrawGridLines(false);
            lineChart.getAxisRight().setDrawGridLines(false);


            YAxis rightYAxis = lineChart.getAxisRight();
            rightYAxis.setEnabled(false);
            YAxis leftYAxis = lineChart.getAxisLeft();
            leftYAxis.setEnabled(true);
            XAxis topXAxis = lineChart.getXAxis();
            topXAxis.setEnabled(false);


            XAxis xAxis = lineChart.getXAxis();
            xAxis.setGranularity(1f);
            //xAxis.setCenterAxisLabels(true);
            xAxis.setEnabled(true);
            xAxis.setDrawGridLines(false);
            xAxis.setPosition(XAxis.XAxisPosition.BOTTOM);
            xAxis.setLabelRotationAngle(0f);
            xAxis.setDrawAxisLine(true);
            xAxis.setSpaceMin(0.4f);

            set1.setLineWidth(2f);
            set1.setCircleRadius(3f);
            set1.setDrawValues(true);


            lineChart.getXAxis().setValueFormatter(new com.github.mikephil.charting.formatter.IndexAxisValueFormatter(xAxisValues));

            LineData data = new LineData(dataSets);

            lineChart.setData(data);
            lineChart.animateX(2000);
            lineChart.invalidate();
            lineChart.getLegend().setEnabled(false);
            lineChart.getDescription().setEnabled(false);
        }

    }

    public void agregarCabecera(int recursocabecera)
    {
        TableRow.LayoutParams layoutCelda;
        TableRow fila = new TableRow(getActivity());
        TableRow.LayoutParams layoutFila = new TableRow.LayoutParams(TableRow.LayoutParams.MATCH_PARENT, TableRow.LayoutParams.MATCH_PARENT);
        fila.setLayoutParams(layoutFila);

        String[] arraycabecera = rs.getStringArray(recursocabecera);
        COLUMNAS = arraycabecera.length;

        for(int i = 0; i < arraycabecera.length; i++)
        {
            TextView texto = new TextView(getActivity());
            layoutCelda = new TableRow.LayoutParams( TableRow.LayoutParams.MATCH_PARENT);
            texto.setText(arraycabecera[i]);
            texto.setGravity(Gravity.CENTER_HORIZONTAL);
            texto.setTypeface(texto.getTypeface(),Typeface.BOLD);
            texto.setTextColor(Color.BLACK);

            //texto.setTextAppearance(actividad, R.style.estilo_celda);
            texto.setBackgroundResource(R.drawable.cabecera_tabla);
            texto.setLayoutParams(layoutCelda);

            fila.addView(texto);
        }

        tabla.addView(fila);
        filas.add(fila);

        FILAS++;
    }
    public void agregarFilaTabla(ArrayList<String> elementos)
    {
        TableRow.LayoutParams layoutCelda;
        TableRow.LayoutParams layoutFila = new TableRow.LayoutParams(TableRow.LayoutParams.MATCH_PARENT, TableRow.LayoutParams.MATCH_PARENT);
        TableRow fila = new TableRow(getActivity());
        fila.setLayoutParams(layoutFila);

        for(int i = 0; i< elementos.size(); i++)
        {
            TextView texto = new TextView(getActivity());
            texto.setText(String.valueOf(elementos.get(i)));
            texto.setGravity(Gravity.CENTER_HORIZONTAL);
            if(i==0){
                texto.setTypeface(texto.getTypeface(),Typeface.BOLD);
            }
            texto.setBackgroundResource(R.drawable.celda_tabla);
            layoutCelda = new TableRow.LayoutParams(TableLayout.LayoutParams.FILL_PARENT, TableRow.LayoutParams.MATCH_PARENT);
            texto.setLayoutParams(layoutCelda);

            fila.addView(texto);
        }

        tabla.addView(fila);
        filas.add(fila);

        FILAS++;
    }
    public void borrarDatosTabla()
    {
        tabla.removeViews(1,4);
        filas.remove(4);
        filas.remove(3);
        filas.remove(2);
        filas.remove(1);
        FILAS=1;

    }

    private int obtenerAnchoPixelesTexto(String texto)
    {
        Paint p = new Paint();
        Rect bounds = new Rect();
        p.setTextSize(60);

        p.getTextBounds(texto, 0, texto.length(), bounds);
        return bounds.width();
    }

    public void actualizarTabla(double pm0,double pmin0,double pmax0,double pm1,double pmin1,double pmax1,
                                double pm2,double pmin2,double pmax2, double pm3, double pmin3, double pmax3){
        DecimalFormat df = new DecimalFormat("#.00");
        borrarDatosTabla();



        ArrayList<String> elementos = new ArrayList<String>();
        elementos.add("Sueño");
        if(pm0!=pm0){
            elementos.add("N/A");
            elementos.add("N/A");
            elementos.add("N/A");
        }else{
            elementos.add(df.format(pm0)+"");
            elementos.add(pmin0+"");
            elementos.add(pmax0+"");
        }
        agregarFilaTabla(elementos);
        elementos.clear();

        elementos.add("Reposo");
        if(pm1!=pm1){
            elementos.add("N/A");
            elementos.add("N/A");
            elementos.add("N/A");
        }else{
            elementos.add(df.format(pm1)+"");
            elementos.add(pmin1+"");
            elementos.add(pmax1+"");
        }
        agregarFilaTabla(elementos);
        elementos.clear();

        elementos.add("Moderada");
        if(pm2!=pm2){
            elementos.add("N/A");
            elementos.add("N/A");
            elementos.add("N/A");
        }else{
            elementos.add(df.format(pm2)+"");
            elementos.add(pmin2+"");
            elementos.add(pmax2+"");
        }
        agregarFilaTabla(elementos);
        elementos.clear();

        elementos.add("Intensa");
        if(pm3!=pm3){
            elementos.add("N/A");
            elementos.add("N/A");
            elementos.add("N/A");
        }else{
            elementos.add(df.format(pm3)+"");
            elementos.add(pmin3+"");
            elementos.add(pmax3+"");
        }
        agregarFilaTabla(elementos);
        elementos.clear();

    }

    public void enviar_notificacion(String texto){

        byte[] value = new byte[2];
        value[0]=0x05;
        value[1]=0x02;

        byte[] btexto=texto.getBytes();
        byte[] para_enviar=new byte[value.length+btexto.length];
        para_enviar[0]=value[0];
        para_enviar[1]=value[1];
        for (int i=2;i<para_enviar.length;i++){
            para_enviar[i]=btexto[i-2];
        }

        BluetoothGattCharacteristic c=new BluetoothGattCharacteristic(UUID.fromString(SampleGattAttributes.UUID_CHARACTERISTIC_NOTIFICATION),0,0);

        for (int i=0;i<mGattCharacteristics.size();i++){
            for(int j=0;j<mGattCharacteristics.get(i).size();j++){
                //Se lee la caracteristica de la notificacion
                if(mGattCharacteristics.get(i).get(j).getUuid().toString().equals(SampleGattAttributes.UUID_CHARACTERISTIC_NOTIFICATION)){
                    c=mGattCharacteristics.get(i).get(j);

                }
            }
        }

        boolean b=bluetoothLeService.writeCharacteristic(c,para_enviar);
    }

    public void escribirEnFichero(String filename, String datos){

        try {
            FileOutputStream fou = getActivity().openFileOutput(filename, Context.MODE_APPEND);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fou);
            outputStreamWriter.append(datos+"\n");
            outputStreamWriter.close();
        }catch (IOException e) {
            Log.e("Exception", "File write failed: " + e.toString());
        }
    }
    public void escribirEnFicheroP(String filename, String datos){

        try {
            FileOutputStream fou = getActivity().openFileOutput(filename, Context.MODE_PRIVATE);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fou);

            outputStreamWriter.write(datos);
            outputStreamWriter.close();
        }catch (IOException e) {
            Log.e("Exception", "File write failed: " + e.toString());
        }
    }

    public String leerFichero(String nombre){
        String s="";
        try {
            InputStream inputStream = getActivity().openFileInput(nombre);

            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String receiveString = "";

                while ((receiveString = bufferedReader.readLine()) != null) {
                    s=s+receiveString+"\n";
                    Log.d("leerFichero",receiveString);
                }
                inputStream.close();
            }
        } catch (FileNotFoundException e) {
            Log.e("login activity", "File not found: " + e.toString());
        } catch (IOException e) {
            Log.e("login activity", "Can not read file: " + e.toString());
        }

        Date d=new Date(System.currentTimeMillis());
        String[] a=d.toString().split(" ");
        Log.d("yyyyy",a[1]+"_"+a[2]+"_"+a[5]);
        return s;
    }

    public void displayGattServices(List<BluetoothGattService> gattServices) {
        if (gattServices == null) return;
        // Definimos variables para servicios y características
        String uuid = null;
        String unknownServiceString = getResources().
                getString(R.string.unknown_service);
        String unknownCharaString = getResources().
                getString(R.string.unknown_characteristic);
        ArrayList<HashMap<String, String>> gattServiceData =
                new ArrayList<HashMap<String, String>>();
        ArrayList<ArrayList<HashMap<String, String>>> gattCharacteristicData
                = new ArrayList<ArrayList<HashMap<String, String>>>();
        mGattCharacteristics =
                new ArrayList<ArrayList<BluetoothGattCharacteristic>>();

        // Bucle que recorre todos los servicios disponibles.
        for (BluetoothGattService gattService : gattServices) {
            HashMap<String, String> currentServiceData =
                    new HashMap<String, String>();
            //Se obtiene el uuid del servicio
            uuid = gattService.getUuid().toString();
            //Se añade el uuid y el nombre
            currentServiceData.put(
                    LIST_NAME, SampleGattAttributes.
                            lookup(uuid, unknownServiceString));
            currentServiceData.put(LIST_UUID, uuid);
            gattServiceData.add(currentServiceData);

            ArrayList<HashMap<String, String>> gattCharacteristicGroupData =
                    new ArrayList<HashMap<String, String>>();

            //Se obtienen las características del servicio
            List<BluetoothGattCharacteristic> gattCharacteristics =
                    gattService.getCharacteristics();
            ArrayList<BluetoothGattCharacteristic> charas =
                    new ArrayList<BluetoothGattCharacteristic>();
            // Bucle que recorre las caracteristicas del servicio
            for (BluetoothGattCharacteristic gattCharacteristic :
                    gattCharacteristics) {
                //Se añade la caracteristica a la lista
                charas.add(gattCharacteristic);
                HashMap<String, String> currentCharaData =
                        new HashMap<String, String>();
                uuid = gattCharacteristic.getUuid().toString();
                currentCharaData.put(
                        LIST_NAME, SampleGattAttributes.lookup(uuid,
                                unknownCharaString));
                currentCharaData.put(LIST_UUID, uuid);
                gattCharacteristicGroupData.add(currentCharaData);
            }
            mGattCharacteristics.add(charas);
            gattCharacteristicData.add(gattCharacteristicGroupData);

            activarNotificaciones();
            spinner.setEnabled(true);
            bAhora.setEnabled(true);
            bCalibrar.setEnabled(true);
        }
    }





}
