package es.uniovi.healthappv2;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;

import androidx.core.app.NotificationCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wearable.CapabilityClient;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.DataClient;
import com.google.android.gms.wearable.DataEvent;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.MessageClient;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.PutDataMapRequest;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.Wearable;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;

public class TransferService extends Service implements DataClient.OnDataChangedListener,
        MessageClient.OnMessageReceivedListener, CapabilityClient.OnCapabilityChangedListener{

    int c=0;
    DataClient dataClient;

    public TransferService() {
    }

    @Override
    public IBinder onBind(Intent intent) {
        // TODO: Return the communication channel to the service.
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void onCreate() {
        dataClient= Wearable.getDataClient(this);

        //Se añaden los listeners necesirios para recibir información desde el movil
        Wearable.getMessageClient(this).addListener(this);
        Wearable.getCapabilityClient(this)
                .addListener(this, Uri.parse("wear://"), CapabilityClient.FILTER_REACHABLE);
        Log.d("onCreate()-DatosService","Create");
        Wearable.getDataClient(this).addListener(this);

    }
    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {

        //Al ser un servicio en segundo plano hay que mostrar una notificacion que lo indique
        if (Build.VERSION.SDK_INT >= 26) {

            String NOTIFICATION_CHANNEL_ID = "pl.***.***2";
            String channelName = "Communication Service2";
            NotificationChannel chan = new NotificationChannel(NOTIFICATION_CHANNEL_ID, channelName, NotificationManager.IMPORTANCE_NONE);
            chan.setLightColor(Color.BLUE);
            chan.setLockscreenVisibility(Notification.VISIBILITY_PRIVATE);

            NotificationManager manager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
            assert manager != null;
            manager.createNotificationChannel(chan);

            NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(this,NOTIFICATION_CHANNEL_ID);
            Notification notification = notificationBuilder.setOngoing(true)
                    .setContentTitle(this.getString(R.string.app_name))
                    .setPriority(NotificationManager.IMPORTANCE_MIN)
                    .setCategory(Notification.CATEGORY_SERVICE)
                    .build();
            startForeground(4, notification);
        } else {
            startForeground(3, new Notification());
        }
        return START_STICKY;
    }



    @Override
    public void onDataChanged(DataEventBuffer dataEvents) {
        Log.d("sendData()", "data changeeed");
        //Se invoca si hay algun cambio en la capa de datos.
        for (DataEvent event : dataEvents) {
            if (event.getType() == DataEvent.TYPE_CHANGED) {
                // DataItem changed
                DataItem item = event.getDataItem();
                if (item.getUri().getPath().compareTo("/count") == 0) {
                    DataMap dataMap = DataMapItem.fromDataItem(item).getDataMap();
                }
            } else if (event.getType() == DataEvent.TYPE_DELETED) {
            }
        }
    }

    public void sendDataPulso() {
        Log.d("sendData()", "sending data");

        //Se envian los datos de los últimos 15 al movil
        long milis_dia=24*60*60*1000;
        Date d=new Date(System.currentTimeMillis()-milis_dia*15);

        for (int i=14;i>=0;i--) { //Para los ultimos 15 dias
            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            d = new Date(System.currentTimeMillis() - milis_dia * i);
            String[] a = d.toString().split(" ");

            //Para enviar el fichero del pulso completo
            String fichero_leido=leerFichero("ActividadR_" + a[1] + "_" + a[2] + "_" + a[5] + ".txt");


            PutDataMapRequest putDataMapReq = PutDataMapRequest.create("/count"); // create data map
            putDataMapReq.getDataMap().putString("clave1", c++ + "///" + "ActividadR_" + a[1] + "_" + a[2] + "_" + a[5] + ".txt"); //Barras para separar y que siempre cambie la info

            //Para enviar el fichero del pulso completo
            putDataMapReq.getDataMap().putString("clave2", c + "///" + fichero_leido);//Barras para separar y que siempre cambie la info

            //Para marcar cual es el ultimo fichero
            if(i==0){
                putDataMapReq.getDataMap().putString("clave3", c + "///" + "FIN");
            }
            else {
                putDataMapReq.getDataMap().putString("clave3", c + "///" + "SIGUE");
            }


            PutDataRequest putDataReq = putDataMapReq.asPutDataRequest();
            putDataMapReq.setUrgent();


            Task<DataItem> putDataTask = dataClient.putDataItem(putDataReq);
            putDataTask.addOnSuccessListener(
                    new OnSuccessListener<DataItem>() {
                        @Override
                        public void onSuccess(DataItem dataItem) {
                            Log.d("sendData()", "Sending text was successful: " + dataItem);
                        }
                    });
        }
    }

    @Override
    public void onMessageReceived(MessageEvent messageEvent) {
        //Receptor de mensajes desde el movil
        Log.d("onMessageReceived()","INICIO");
        //Se solicita el pulso
        if (messageEvent.getPath().equals("pulso")) {
            byte[] a=messageEvent.getData();
            Log.d("onMessageReceived()","pulsoo");
            sendDataPulso();
        }
        //Se reciben los datos del usuario desde el movil
        if (messageEvent.getPath().equals("datosUsuario")) {
            byte[] a=messageEvent.getData();
            int edad=a[0];
            int fc=a[1];
            //Se guardan los datos y se envian por broadcast
            grabarEnFichero("RDatosUsuario.txt",edad+"&"+fc);
            sendMessageToActivity(edad+"&"+fc);
        }
    }

    @Override
    public void onCapabilityChanged(CapabilityInfo capabilityInfo) {
        Log.d("onCapabilityChanged()","INICIO");
    }

    private void sendMessageToActivity(String datos) {//Para enviar datos por broadcast y mostrar info en la interfaz
        Intent intent = new Intent("DatosUsuario");
        intent.putExtra("DatosUsr", datos);
        LocalBroadcastManager.getInstance(this).sendBroadcast(intent);
    }

    public String leerFichero(String nombre){
        String fichero_leido="";
        try {
            InputStream inputStream = openFileInput(nombre);

            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String receiveString = "";

                while ((receiveString = bufferedReader.readLine()) != null) {
                    fichero_leido=fichero_leido+receiveString+"\n";
                }
                inputStream.close();
            }
        } catch (FileNotFoundException e) {
            Log.e("login activity", "File not found: " + e.toString());
        } catch (IOException e) {
            Log.e("login activity", "Can not read file: " + e.toString());
        }
        return fichero_leido;
    }

    public void grabarEnFichero(String nombre, String data){

        FileOutputStream fou = null;
        try {
            fou = openFileOutput(nombre, Context.MODE_PRIVATE); //Se sobreescriben los ficheros
            Log.d("grabarFichero()","private");
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fou);
        try {
            outputStreamWriter.append(data);
            outputStreamWriter.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }



}
