import numpy as np
import pandas as pd
from sklearn.preprocessing import MinMaxScaler
from sklearn.model_selection import train_test_split, StratifiedKFold, LeaveOneOut
from sklearn.neural_network import MLPClassifier


clf = MLPClassifier(hidden_layer_sizes=[10], max_iter=500)

fichero = './datosActividades.xlsx'
individuos = ['Hombre1', 'Hombre2', 'Mujer1']

data = pd.read_excel(fichero, sheet_name='Hombre1')

for persona in individuos[1:]:
    data = data.append(pd.read_excel(fichero, sheet_name=persona))

data.reset_index(drop=True)

scaler = MinMaxScaler()
X = scaler.fit_transform(data.iloc[:,1:])

target = data.iloc[:,0].values
etiquetas = np.unique(target)
y = np.zeros(target.shape[0], dtype=int)
for i,l in enumerate(etiquetas):
    y[np.argwhere(target == l)] = i

X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=1/3, stratify=y)

clf.fit(X_train, y_train)

clf.score(X_test, y_test)


# # VALIDACIÓN CRUZADA

K = 10
skf = StratifiedKFold(n_splits=K)

r_clf = pd.DataFrame(columns=['Fold', 'Score'])
k = 0
for train_index, test_index in skf.split(X,y):
    clf.fit(X[train_index], y[train_index])
    r_clf.loc[k,:] = [k,clf.score(X[test_index], y[test_index])]
    k += 1
    #print(persona , '->', clf.score(X_test, y_test))
print(r_clf)
print("MEDIA =", r_clf.mean()[1], "\tDESVIACIÓN ESTÁNDAR =", r_clf.std()[1], "\n" )


# # One out

loo=LeaveOneOut()
loo.get_n_splits(X)
print(loo)
clf2 = MLPClassifier(hidden_layer_sizes=[10], max_iter=500)
o_tree = pd.DataFrame(columns=['Fold', 'Score'])
k = 0
for train_index, test_index in loo.split(X):
    clf2.fit(X[train_index], y[train_index])
    o_tree.loc[k,:] = [k,clf2.score(X[test_index], y[test_index])]
    k += 1
    #print("TRAIN:", train_index, "TEST:", test_index)
    #X_train, X_test = X[train_index], X[test_index]
    #y_train, y_test = y[train_index], y[test_index]
    #print(X_train, X_test, y_train, y_test)
    
print(o_tree)
print("MEDIA =", o_tree.mean()[1], "\tDESVIACIÓN ESTÁNDAR =", o_tree.std()[1], "\n" )

