#ifndef CardioPulmonFunctions
#define CardioPulmonFunctions

#include "defines.h"

/* interface */
double Ctimer(void);

long nextPow2(int);

int compara(const void *, const void *);

int buscarFirstIgual     (const int, const MyType*, const MyType);
int buscarFirstMayor     (const int, const MyType*, const MyType);
int buscarFirstMayorIgual(const int, const MyType*, const MyType);

void memSetValueRealComplex(const int, const MyType, MyFFTcompl *);

void suma(const int, MyType*, const MyType*);

int hanning(const int, MyType*);

int rHannFFT(const int, const int, const int, const MyType*, const MyType*, const int, MyType*,              const int, const int, const int);
int cHannFFT(const int, const int, const int, const MyType*, const MyType*, const int, MyType*, MyFFTcompl*, const int, const int, const int);

void epsNMF(const int, MyType*);

void          randNMF(const int, MyType*);
void randNMFmt19937ar(const int, MyType*);

void normNMF(const int, const int, const int, MyType*, MyType*);

MyType distNMF(const int, const int, const int, MyType*, MyType*, MyType*);
int       uNMF(const int, const int, const int, MyType*, MyType*, MyType*, MyType*, int*);

int HSD(const int, const int, const MyType*, const MyType*, MyType**, int*, const int, const int);

int invSpectroExtended(const int, const int, const int, const int, const int, const int, const MyType*,
                       const MyType*, const MyType*, MyType*, MyFFTcompl*, MyFFTcompl*, MyFFTCPUType);

int invSpectro(const int, const int, const int, const int, const int, const MyType*, const MyFFTcompl*, MyFFTcompl*, MyFFTcompl*, MyFFTCPUType);

MyType RollOff(const int, const MyFFTcompl*, const MyType);

MyType    corrCos(const int, const int, const MyType*, const MyType*, MyType*);
MyType corrPatron(const int, const int, const MyType*, const int*,    MyType*);

void simpleRL(const int, const MyType*, MyType*, MyType*);

void oldXcorr(const int, MyType*, const int, const MyType*);

int  AMbPD(const int, const MyType*, int*);

void ReconCorazon(const int, MyFFTcompl*, MyFFTcompl*, const MyFFTcompl*, const MyType*, const MyType*);

MyType BMP(const int, const int, const int, MyFFTcompl*, MyType*, const int);

void linspace(const int, const int, const int, MyType*);

void interpl(const int, const int, const double*, const double*, const double*, double*);

int xcorr(double*, double*, double*, const int, const int);

#endif

