#ifndef DataDefine
#define DataDefine

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>
#include <float.h>
#include <stdbool.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <math.h>

/* double complex z1 = 1.0 + 3.0 * I;
   double complex z2 = 1.0 - 4.0 * I;
   double complex sum = z1 + z2;
   o
   float  complex z1 = 1.0 + 3.0 * I;
   float  complex z2 = 1.0 - 4.0 * I;
   float  complex sum = z1 + z2;   
   o
   MyType complex xxxx
   printf("The sum: Z1 + Z2 = %.2f %+.2fi\n", creal(sum), cimag(sum));
   with:
     creal(z1): get the real part (for float crealf(z1), for long double creall(z1))
     cimag(z1): get the imaginary part (for float cimagf(z1), for long double cimagl(z1))
   Another important point to remember when working with complex numbers is that functions
   like cos(), exp() and sqrt() must be replaced with their complex forms, e.g. ccos(), cexp(), csqrt()

   En el manual de la fftw dice que es mejor usar fftw_complex / fftwf_complex */


#define _GNU_SOURCE 1

#ifdef OMP
  #include <omp.h>
#endif

#ifdef MKL
  #ifdef CBLAS
    #include <mkl.h>
  #endif
#else
  #ifdef CBLAS
    #include <cblas.h>
    #include <lapacke.h>
  #endif
#endif

#include <complex.h>
#include <fftw3.h>
#include "mt19937ar/mt19937ar.h"

/* Constants */
#define PI    3.141592653589793
#define DosPI 6.283185307179586
#define dEPS  2.220446049250313e-16 // small value to avoid zeros double precision like matlab. 1e-16 is valid?
#define sEPS  2.2204460e-08         // small value to avoid zeros simple precision. 1e-8 is valid?
#define eta   10e-5                 // cota de error usada en uNMF

#define coefcoThreshold  0.00
#define energyThreshold  0.85
#define fcThreshold    260.00
#define simThreshold     0.40

#define freqHz     8000.000 // The signal sample rate
#define seconds       0.064 // Seconds of... (freqHz*mseg)=window size (hanning)
#define secondsHSD    0.125 // Seconds of... (freqHz*mseg)=window size (hanning) para Heart Sound Detection
#define overlap       0.500 // Signal overlap percentage within windows 0.5 = 50%
#define freqCut      60.000 // [0-freqCut] frecuencias de no solapamiento entre sonidos de corazon y pulmon
#define BPM_min      40.000 // Minimum beat per minute
#define BPM_max     190.000 // Maximum beat per minute


#define bcCorazon  55
#define bcPulmon   64
#define lambda      0.73
#define beta        1.0
#define maxIter   400

/* Local types */
#ifdef SIMPLE
   #define MyType       float
   #define MyTypecompl  float complex
   #define MyFFTcompl   fftwf_complex
   #define MyFFTCPUType fftwf_plan
#else
   #define MyType       double
   #define MyTypecompl  double complex
   #define MyFFTcompl   fftw_complex
   #define MyFFTCPUType fftw_plan
#endif
#define MyFFTGPUType    cufftHandle


struct ValueAndPos
{
    MyType data;
    int    pos; 
};
typedef struct ValueAndPos ValueAndPos;



#define WAVHeaderLength 40  // ES 44 PERO leemos los 4 primeros bytes primero para saber si es...

struct WAVHeader
{
    unsigned char header[WAVHeaderLength]; /* Whole header                      */
    long num_samples;                      /* num_samples=data_size/block_align */
    /* NOT USED                                                                 */
    /* char riff[4];                  String "RIFF".                            */
    /* unsigned int size;             Overall size of file in bytes.            */
    /* char wave[4];                  String "WAVE".                            */
    /* char  fmt[4];                  String "fmt".                             */
    /* unsigned int fmt_length;       Length of the format data.                */
    /* unsigned int format_type;      Format type. 1 PCM, 3 IEEE float, etc.    */
    /* unsigned int channels;         Number of channels                        */
    /* unsigned int sample_rate;      Sampling rate (samples per second or Hz)  */
    /* unsigned int byte_rate;        sample_rate*channels*bits_per_sample/8    */
    /* unsigned int block_align;      Bytes for sample including all channels   */
    /* unsigned int bits_per_sample;  Bits per sample, 8 8bits, 16 16bits, ...  */
    /* char data_header[4];           String "DATA" or "FLLR" string            */
    /* unsigned int data_size;        Size of the data section.                 */
    /* unsigned int bytes_per_sample; Equal to bits_per_sample*channels/8.      */
};
typedef struct WAVHeader WAVHeader;

/* For check errors */
#define OK            0
#define ErrOpenFile  -1
#define ErrReadFile  -2
#define ErrWriteFile -3
#define ErrWavFormat -4
#define ErrNULL      -5

#define CHECKERR(x) do { if((x)<0) { \
   printf("Error %d calling %s line %d\n", x, __FILE__, __LINE__);\
   return x;}} while(0)

#define CHECKNULL(x) do { if((x)==NULL) { \
   printf("NULL (when open file or  memory allocation calling %s line %d\n", __FILE__, __LINE__);\
   return ErrNULL;}} while(0)

#define CUDAERR(x) do { if((x)!=cudaSuccess) { \
   printf("CUDA error: %s : %s, line %d\n", cudaGetErrorString(x), __FILE__, __LINE__);\
   return EXIT_FAILURE;}} while(0)

#define CUBLASERR(x) do { if((x)!=CUBLAS_STATUS_SUCCESS) { \
   printf("CUBLAS error: %s, line %d\n", __FILE__, __LINE__);\
   return EXIT_FAILURE;}} while(0)

#define CUFFTERR(x) do { if((x)!=CUFFT_SUCCESS) { \
   printf("CUFFT error: %s, line %d\n", __FILE__, __LINE__);\
   return EXIT_FAILURE;}} while(0)

#ifndef min
   #define min(x,y) ((x < y) ? x : y)
#endif

#ifndef max
   #define max(x,y) ((x > y) ? x : y)
#endif

#endif
